/* - AdvServoPositionListener -
 * Servo position change event handling code
 *
 * Copyright 2007 Phidgets Inc.  
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */

package listeners;

import com.phidgets.event.ServoPositionChangeListener;
import com.phidgets.event.ServoPositionChangeEvent;

import javax.swing.JComboBox;
import javax.swing.JTextField;
/**
 *
 * @author Owner
 */
public class AdvServoPositionListener implements ServoPositionChangeListener{
    
    private JComboBox servoCmb;
    private JTextField actPosTxt;
    
    /** Creates a new instance of AdvServoPositionListener */
    public AdvServoPositionListener(JComboBox servoCmb, JTextField actPosTxt)
    {
        this.servoCmb = servoCmb;
        this.actPosTxt = actPosTxt;
    }

    public void servoPositionChanged(ServoPositionChangeEvent servoPositionChangeEvent)
    {
        if(servoPositionChangeEvent.getIndex() == ((Integer)servoCmb.getSelectedItem()).intValue())
        {
            actPosTxt.setText(Double.toString(servoPositionChangeEvent.getValue()));
        }
    }
    
}
